#include <iostream>
#include <cstdlib>
#include "scripting.h"

script::script(){}

bool script::read( std::string &filename, char type) {
	using namespace std;

	ifstream file;
	file.open(filename.c_str());
	if(!file) {
		cerr << "Error: " << filename << " could not be opened" << endl;
		exit(1);
	}
	while(!file.eof()) {
		string line;
		while (getline(file, line)) {
			if( type == 'c' ) {
				read_config(line);
			}
			if( type == 's') {
				read_script(line);
			}
			if( (type != 'c') and (type != 's') ) {
				cerr << "Error: " << type << " invalid parameter for const char* type in script::read()" << endl;
			}
		}	
	}
	file.close();
	return true;
}

bool script::read_config(std::string &r_line) {
	using namespace std;

	// find variables
	int unsigned i, a; 						//  i  = position, a = length
	
	if( r_line.find("@") != string::npos ) {
		
		//variable name
                i = r_line.find("@")+1;  	                       // name start
                a = r_line.find("=");           	               // name end
                a = a - i;                              	       // name length
                string name = r_line.substr(i,a);
		cout << "Variable Name: " << name << endl;

		//check if string
		if( r_line.find("\"") != string::npos ) {
			i = r_line.find("\"")+1;			// find beginning (first quote + 1)
			a = r_line.find("\"", i); 			// find ending 
			a = a - i;					// find length
			string s_value =  r_line.substr(i,a);
                        cout << "Value: " << s_value << endl;

		}

		// else treat as integer
		else {
			//variable value
			i = r_line.find("=")+1; 			// value start
			a = r_line.find(";"); 				// value end
			a = a - i; 					//value length
			int i_value = atoi(r_line.substr(i,a).c_str());
			cout << "Value: " << i_value << endl;
		}

	}
	
	return true;
}

bool script::read_script(std::string &c_line) {
	using namespace std;
	cout << "Reading \"" << c_line << "\" as script file." << endl;
	return true;
}
			
