#include <iostream>
#include <fstream>
#include <iostream>
#include <string>
#include <string.h>
#include <stdlib.h>
#include "configRead.h"
#include "scripting.h"

int g_debug_mode;
std::string g_title, g_developer, g_script_path_1, g_script_path_2, g_script_path_3;
int unsigned section = 0;
script startup_script;


void read_config_line(std::string& cLine, int count) 
{
		using namespace std;
		
		unsigned int i;
		string tempStr;
		
		//find comments
		if( cLine.find("#", 0) != string::npos ) 
		{
			cLine = "";
		}
		//global opening
		if(cLine.find("$globals") != string::npos ) 
		{
			cout << endl << "\tReading in globals...";
			section = GLOBALS;
		}
		//global vars
		if(section == GLOBALS) 
		{
			if((i = cLine.find("@debug_mode")) != string::npos ) 
			{
				tempStr = cLine.substr(i+12);
				g_debug_mode = atoi(tempStr.c_str());
			}
			if((i = cLine.find("@title")) != string::npos ) 
			{
				g_title = cLine.substr(i+7);
			}
			if((i = cLine.find("@developer")) != string::npos ) 
			{
				g_developer = cLine.substr(i+11);
			}
			if((i = cLine.find("@script1_path") != string::npos) ) 
			{
				g_script_path_1 = cLine.substr(i+13);
			}
			if((i = cLine.find("@script2_path") != string::npos) ) 
			{
				g_script_path_2 = cLine.substr(i+13);
			}
			if((i = cLine.find("@script3_path") != string::npos) ) 
			{
				g_script_path_3 = cLine.substr(i+13);
			}
		}
		//global closing
		if( (section == GLOBALS) && ( (cLine.find("$/globals")) != string::npos) ) 
		{
			cout << "done." << endl;
			section = CLOSED;
		}
		//startup script opening
		if( (cLine.find("$startup_script") != string::npos) ) 
		{
			section = SCRIPTS;
			cout << "\tReading in startup script...";
		}
		if(section == SCRIPTS) 
		{
			//find script opening
			if(((i = cLine.find("%")) != string::npos)  && ( (cLine.substr(i+1,1) != "/")))  
			{
				startup_script.name = cLine.substr(i+1);
			}
			//find script commands
			if((i = cLine.find("&")) != string::npos) 
			{
				tempStr = cLine.substr(i);
				startup_script = commandFind(tempStr,startup_script);
				startup_script.cmdCount++;
			}
		}
		if((cLine.find("$/startup_script") != string::npos)) 
		{
				section = CLOSED;
				cout << "done." << endl;
		}
		
}

int configRead() 
{
	using namespace std;
	
	int state, line_count;
	line_count = 1;
	startup_script.cmdCount = 0;
	
	string line;
	fstream config("config.dat");
	if(!config) 
	{
		cout << "\tCannot open file for output.\n" << endl;
		state = 0;
	}
	if( config.is_open() ) 
	{
		while(!config.eof()) 
		{
			getline(config, line);
			read_config_line(line, line_count);
			line_count++;
		}
		state = 1;
	}
	
	return state;	
}	


