#include <iostream>
#include "configRead.h"
#include "scripting.h"

//"Boots" the engine; first file to run

int main() 
{
	
	using namespace std;
	
	cout << "Starting up...";
	
	if( !configRead() )
	{
		cerr << "\tConfiguration not read: engine terminated." << endl;
	}
		
	cout << "done." << endl;
	
	if( !readScript(startup_script) ) 
	{
		cerr << "\tScript index could not be read." << endl;
	}
	
	
	
	if(g_debug_mode == 1) 
	{
		cout << endl << endl;
		cout << "Debug mode: " << g_debug_mode << endl;
		cout << "Title: " << g_title << endl;
		cout << "Developer: " << g_developer << endl;
		cout << "Script Paths:" << endl;
		cout << "\t1: " << g_script_path_1 << endl;
		cout << "\t2: " << g_script_path_2 << endl;
		cout << "\t3: " << g_script_path_3 << endl;
		cout << endl << "Startup Script:" << endl;
		cout << "\tScript Name: " << startup_script.name << endl;
		cout << "\tNumber of Commands in Script: " << startup_script.cmdCount << endl;
		for(unsigned int i = 0; i < startup_script.cmdCount; i++) 
		{
			cout << "\t\tCommand " << i+1 << ":" << endl;
			cout << "\t\t\tCommand Index: " << startup_script.index[i] << endl;
			cout << "\t\t\tCommand Parameters: "<< endl;
			
			for(int a = 0; a < 4; a++) 
			{
				cout << "\t\t\t\tParameter " << a+1 << ": " << startup_script.parameters[i][a] << endl;
			}
		}
	}
	
	return 0;

}

